#include <bits/stdc++.h>

using namespace std;

int n;

int N = 30;
int M = 30;

// int N = 2;
// int M = 3;

vector<vector<int>> a;
vector<vector<int>> visited;
vector<pair<int, int>> cur_component;

void dfs(int x, int y) {
    visited[x][y] = true;
    cur_component.push_back({x, y});
    for (int delta_x = -1; delta_x <= 1; delta_x++) {
        for (int delta_y = -1; delta_y <= 1; delta_y++) {
            int new_x = x + delta_x;
            int new_y = y + delta_y;
            if (new_x < 0 || new_x >= N || new_y < 0 || new_y >= M) {
                continue;
            }
            if (a[new_x][new_y] == a[x][y] && visited[new_x][new_y] == 0) {
                dfs(new_x, new_y);
            }
        }
    }
}

void solve() {
    a.clear();
    visited.clear();
    cur_component.clear();

    a.resize(N, vector<int>(M, 0));
    visited.resize(N, vector<int>(M, 0));

    int start_x = rand() % 100000000;
    int start_y = rand() % 100000000;

    for (int i = 0; i < N; i++) {
        for (int j = 0; j < M; j++) {
            cout << "? " << start_x + i << " " << start_y + j << endl;
            char c;
            cin >> c;
            a[i][j] = (c == 'B');
        }
    }

    for (int i = 0; i < N; ++i) {
        for (int j = 0; j < M; ++j) {
            if (visited[i][j] == 0) {
                cur_component.clear();
                dfs(i, j);
                if (cur_component.size() >= n) {
                    cout << "! " << (a[i][j] == 1 ? 'B' : 'W') << " ";
                    for (int k = 0; k < n; k++) {
                        cout << start_x + cur_component[k].first << " " << start_y + cur_component[k].second << " ";
                    }
                    cout << endl;
                    return;
                }
            }
        }
    }
    assert(false);
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    srand(time(0));
    int t;
    cin >> t >> n;
    while (t--) {
        solve();
    }
    return 0;
}