import java.sql.Array;
import java.util.*;


public class Main {
    static class Op {
        char type;
        int v;
        boolean async;

        Op(char type, int v, boolean async) {
            this.type = type;
            this.v = v;
            this.async = async;
        }
    }


    public static void main(String[] args) {
        Scanner sc = new Scanner(System.in);

        int n = sc.nextInt();
        Main.Op[] ops = new Main.Op[n];

        for (int i = 0; i < n; i++) {
            char type = sc.next().charAt(0);
            int v = sc.nextInt();
            String s = sc.next();
            boolean async = s.equals("async");
            ops[i] = new Main.Op(type, v, async);
        }

        Set<Long> curVals = new HashSet();

        List<Main.Op> block = new ArrayList<>();

        for (int i = 0; i < n; i++) {
            Main.Op op = ops[i];
            if (op.async) {
                block.add(op);
            } else {
                curVals = applyBlock(curVals, block);
            }

            block.clear();
            curVals = applySync(curVals, op);
        }

        System.out.print(curVals.size());

    }

    static Set<Long> applyBlock(Set<Long> startVals, List<Main.Op> block){
        if(block.isEmpty()) return startVals;
        Set<Long> vals = new HashSet<>(startVals);
        for(Main.Op op:block){
            Set<Long> newVals = new HashSet<>();
            if(op.type == '+'){
                for(long x:vals){
                    newVals.add(x+op.v);
                }
            }else{
                for(long x: vals){
                    newVals.add(x+op.v);
                }
                vals = newVals;
            }
        }
        return vals;
    }

    static Set<Long> applySync(Set<Long> vals, Main.Op op){
        Set<Long> newVals = new HashSet();
        if(op.type == '+'){
            for(long x : vals) newVals.add(x+op.v);
        }else{
            for(long x: vals) newVals.add(x*op.v);
        }
        return newVals;
    }
}



