def can_play_melody(melody, key_positions):
    possible_keys = set(key_positions[melody[0]])
    
    for note in melody[1:]:
        next_keys = set()
        for k in key_positions[note]:
         
            if any(abs(k - prev) <= 3 for prev in possible_keys):
                next_keys.add(k)
        if not next_keys:
            return False 
        possible_keys = next_keys
    return True

t = int(input())
melodies = [input().strip() for _ in range(t)]


key_positions = {
    'A': [1, 8, 15, 22, 29, 36, 43, 50],
    'B': [2, 9, 16, 23, 30, 37, 44, 51],
    'C': [3, 10, 17, 24, 31, 38, 45, 52],
    'D': [4, 11, 18, 25, 32, 39, 46],
    'E': [5, 12, 19, 26, 33, 40, 47],
    'F': [6, 13, 20, 27, 34, 41, 48],
    'G': [7, 14, 21, 28, 35, 42, 49]
}


for melody in melodies:
    print("Yes" if can_play_melody(melody, key_positions) else "No")
