def is_lucky_time(hour, minute):
    # Convert to four-digit format HH:MM
    hh = f"{hour:02d}"  # Pad hour with leading zero
    mm = f"{minute:02d}"  # Pad minute with leading zero
    time_str = hh + mm  # e.g., "1239" for 12:39

    # Pattern 1: X2:39 (hours ending in 2, minutes 39)
    if hh[1] == '2' and mm == '39':
        return True

    # Pattern 2: 2X:39 (hours 20, 22, 23; minutes 39)
    if hh[0] == '2' and hh[1] in '023' and mm == '39':
        return True

    # Pattern 3: 23:X9 (hour 23; minutes 09, 39, 99)
    if hh == '23' and mm[1] == '9' and mm[0] in '039':
        return True

    # Pattern 4: 23:9X (hour 23; minutes 90 to 99)
    if hh == '23' and mm[0] == '9':
        return True

    return False


def count_lucky_times(H, M):
    count = 0
    # Check only relevant hours and minutes to optimize
    # Relevant hours: ending in 2 (02, 12, ..., 92) or starting with 2 (20, 22, 23)
    hours = []
    for x in range(10):  # For X2 (02, 12, ..., 92)
        h = 10 * x + 2
        if h < H:
            hours.append(h)
    for x in [0, 2, 3]:  # For 2X (20, 22, 23)
        h = 20 + x
        if h < H:
            hours.append(h)
    hours = sorted(set(hours))  # Remove duplicates (e.g., 22 from both patterns)

    # Relevant minutes: 09, 39, 90 to 99
    minutes = [9, 39]
    if M > 99:
        minutes.append(99)
    for m in range(90, min(100, M)):  # For 90 to min(99, M-1)
        minutes.append(m)
    minutes = sorted(set(minutes))  # Ensure unique minutes

    # Check each hour-minute combination
    for h in hours:
        for m in minutes:
            if h < H and m < M:  # Ensure within bounds
                if is_lucky_time(h, m):
                    count += 1

    return count


# Read input
H, M = map(int, input().split())

# Compute and output result
print(count_lucky_times(H, M))