def calculate_areas_simple(numbers):

    if not numbers:
        return 0, 0

    min_element = min(numbers)
    total_sum = sum(numbers)

    area1 = min_element * (total_sum - min_element)

    aim = total_sum // 2
    dp = {0}

    for number in numbers:
        new_sums = set()
        for s in dp:
            new_sum = s + number
            if new_sum <= aim:
                new_sums.add(new_sum)
        dp.update(new_sums)

    s1 = max(dp)
    s2 = total_sum - s1

    area2 = s1 * s2
    
    return area1, area2

if __name__ == "__main__":

    while True:
        try:
            N = int(input())
            if 2 <= N <= 7:
                break
            else:
                print("error!")
        except ValueError:
            print("Invalid")

    while True:
        try:
            user_input = input()
            input_numbers = [int(x) for x in user_input.split()]
            
            if len(input_numbers) == N:
                if any(l <= 0 for l in input_numbers):
                    print("Numbers should be positive")
                else:
                    break
            else:
                print("invalid")
                
        except ValueError:
            print("Invalid")
        

    min_area, max_area = calculate_areas_simple(input_numbers) 
    print(min_area,max_area)
 