import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.*;

public class Main {
    static class FastReader {
        BufferedReader br;
        StringTokenizer st;
        FastReader() {
            br = new BufferedReader(new InputStreamReader(System.in));
        }
        String next() {
            try {
                while(st == null || !st.hasMoreElements()) {
                    st = new StringTokenizer(br.readLine());
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
            return st.nextToken();
        }
        Integer nextInt() {
            return Integer.parseInt(next());
        }
        Long nextLong() {
            return Long.parseLong(next());
        }
        String nextLine() {
            String str = "";
            try {
                str = br.readLine();
            } catch(IOException e) {
                e.printStackTrace();
            }
            return str;
        }
    }
    static FastReader scan = new FastReader();
    static double dis(int x1, int y1, int x2, int y2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }
    static long gcd(long a, long b) {
        return (b == 0 ? a : gcd(b, a % b));
    }
    static void solve() {
        int n = scan.nextInt();
        int[][] arr = new int[n][2];
        List<Double> a = new ArrayList<>();
        for(int i = 0; i < n; i++) {
            for(int j = 0; j < 2; j++) arr[i][j] = scan.nextInt();
        }
        int in1 = 0, in2 = 0;
        double mx = 0;
        for(int i = 0; i < n; i++) {
            for(int j = i + 1; j < n; j++) {
                double x = dis(arr[i][0], arr[i][1], arr[j][0], arr[j][1]);
                if(x > mx) {
                    mx = x;
                    in1 = i;
                    in2 = j;
                }
            }
        }
        long A = arr[in1][0] - arr[in2][0], B = arr[in1][1] - arr[in2][1];
        long g = gcd(A, B);
        A /= g;
        B /= g;
        long C1 = - A * arr[in1][0] - B * arr[in1][1], C2 = - A * arr[in2][0] - B * arr[in2][1];
        System.out.println(A + " " + B + " " + C1);
        System.out.println(A + " " + B + " " + C2);
    }
    public static void main(String[] args) {
        int T = 1;
//        T = scan.nextInt();
        while(T-- > 0) solve();
    }

}