﻿#include <iostream>
#include <vector>
#include <string>

const int MAX_DIST = 3;

int main() {
    int t;
    std::cin >> t;
    std::vector<std::string> melody(t);
    for (int i = 0; i < t; ++i) {
        std::cin >> melody[i];
    }

    std::vector<char> keys;
    for (int i = 0; i < 52; ++i) {
        keys.push_back("ABCDEFG"[i % 7]);
    }


    std::vector<int> positions[7];
    for (int i = 0; i < 52; ++i) {
        positions[keys[i] - 'A'].push_back(i);
    }

    std::vector<std::string> results;

    for (const std::string& s : melody) {
        std::vector<int> current = positions[s[0] - 'A'];
        bool ok = true;

        for (int i = 1; i < s.size(); ++i) {
            std::vector<int> next;
            char note = s[i];
            for (int pos : positions[note - 'A']) {
                for (int prev : current) {
                    if (abs(pos - prev) <= MAX_DIST) {
                        next.push_back(pos);
                        break;
                    }
                }
            }
            if (next.empty()) {
                ok = false;
                break;
            }
            current = next;
        }

        results.push_back(ok ? "yes" : "no");
    }

    for (const std::string& res : results) {
        std::cout << res << '\n';
    }

    return 0;
}
