#include <iostream>
#include <vector>
#include <array>
using namespace std;

int main() {
    int n;
    cin >> n;
    int R = n - 1,rows = 2 * n - 1;

    struct Cell { 
        int x, y, z;
        int val; 
    };
    vector<Cell> cells;
    cells.reserve(rows * n + 10);

    for (int i = 0; i < rows; ++i) {
        int r = -R + i;
        int qmin = max(-R, -r - R);
        int qmax = min(R, -r + R);
        int cnt = qmax - qmin + 1;
        for (int j = 0; j < cnt; ++j) {
            int v;
            cin >> v;
            int q = qmin + j;
            int x = q;
            int z = r;
            int y = -x - z;
            cells.push_back({ x,y,z,v });
        }
    }

    string ops;
    if (!(cin >> ops)) ops = "";

    auto mul = [](const array<array<int, 3>, 3>& A, const array<array<int, 3>, 3>& B) {
        array<array<int, 3>, 3> C{};
        for (int i = 0; i < 3; ++i) for (int j = 0; j < 3; ++j) {
            int s = 0;
            for (int k = 0; k < 3; ++k) s += A[i][k] * B[k][j];
            C[i][j] = s;
        }
        return C;
        };

    array<array<int, 3>, 3> I{};
    I[0] = { 1,0,0 }; I[1] = { 0,1,0 }; I[2] = { 0,0,1 };

    array<array<int, 3>, 3> MR{};
    MR[0] = { 0,0,-1 };
    MR[1] = { -1,0,0 };
    MR[2] = { 0,-1,0 };

    array<array<int, 3>, 3> ML{};
    ML[0] = { 0,-1,0 };
    ML[1] = { 0,0,-1 };
    ML[2] = { -1,0,0 };

    array<array<int, 3>, 3> MT{};
    MT[0] = { 0,1,0 };
    MT[1] = { 1,0,0 };
    MT[2] = { 0,0,1 };

    array<array<int, 3>, 3> M = I;
    for (char c : ops) {
        if (c == 'R') {
            M = mul(MR, M);
        }
        else if (c == 'L') {
            M = mul(ML, M);
        }
        else if (c == 'T') {
            M = mul(MT, M);
        }
    }

    vector<vector<int>> out(rows);
    for (int i = 0; i < rows; ++i) {
        int r = -R + i;
        int qmin = max(-R, -r - R);
        int qmax = min(R, -r + R);
        int cnt = qmax - qmin + 1;
        out[i].assign(cnt, 0);
    }

    for (const Cell& c : cells) {
        int x = c.x, y = c.y, z = c.z;
        int xp = M[0][0] * x + M[0][1] * y + M[0][2] * z;
        int yp = M[1][0] * x + M[1][1] * y + M[1][2] * z;
        int zp = M[2][0] * x + M[2][1] * y + M[2][2] * z;
        int q2 = xp;
        int r2 = zp;
        int row = r2 + R;
        int qmin2 = max(-R, -r2 - R);
        int idx = q2 - qmin2;
        if (row < 0 || row >= rows) continue;
        if (idx < 0 || idx >= (int)out[row].size()) continue;
        out[row][idx] = c.val;
    }

    for (int i = 0; i < rows; ++i) {
        for (int j = 0; j < (int)out[i].size(); ++j) {
            if (j) cout << ' ';
            cout << out[i][j];
        }
        cout << '\n';
    }

    return 0;
}