def solve():
    t = int(input())
    notes = "ABCDEFG"
    idx = {ch: i for i, ch in enumerate(notes)}
    
    # Precompute positions for each note
    positions = {ch: [] for ch in notes}
    for pos in range(52):
        positions[notes[pos % 7]].append(pos)
    
    for _ in range(t):
        s = input().strip()
        # Initial range for first note
        min_pos = min(positions[s[0]])
        max_pos = max(positions[s[0]])
        possible = True
        for ch in s[1:]:
            # Find all positions for ch within [min_pos-3, max_pos+3]
            available = [p for p in positions[ch] if min_pos - 3 <= p <= max_pos + 3]
            if not available:
                possible = False
                break
            min_pos = min(available)
            max_pos = max(available)
        print("Yes" if possible else "No")

if __name__ == "__main__":
    solve()