MOD = 10**9 + 7
def mod_inverse(a, m):
    def extended_gcd(a, b):
        if a == 0:
            return b, 0, 1
        gcd, x1, y1 = extended_gcd(b % a, a)
        x = y1 - (b // a) * x1
        y = x1
        return gcd, x, y
    
    _, x, _ = extended_gcd(a, m)
    return (x % m + m) % m
t = int(input())

for _ in range(t):
    p, m = map(int, input().split())
    n = 2 * p + m
    numerator = (n % MOD) * ((n + 1) % MOD) % MOD
    denominator = (2 * p) % MOD
    inv_denominator = mod_inverse(denominator, MOD)
    result = (numerator * inv_denominator) % MOD
    print(result)
