#include <bits/stdc++.h>
#define f first
#define s second
using namespace std;
typedef long long ll;

struct Cell {
    int x, y, z;
    int value;
};

Cell rotateR(const Cell &c) { return {-c.z, -c.x, -c.y, c.value}; }
Cell rotateL(const Cell &c) { return {-c.y, -c.z, -c.x, c.value}; }
Cell reflectT(const Cell &c) { return {c.y, c.x, c.z, c.value}; }

Cell rotateK(Cell c, int k) {
    k = (k % 6 + 6) % 6;
    for (int i = 0; i < k; i++) c = rotateR(c);
    return c;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    cin >> n;
    int R = n - 1;
    vector<Cell> cells;
    cells.reserve(3 * n * n);
    for (int y = -R; y <= R; ++y) {
        int x_min = max(-R, -y - R);
        int x_max = min(R, -y + R);
        for (int x = x_min; x <= x_max; ++x) {
            int z = -x - y;
            int val;
            cin >> val;
            cells.push_back({x, y, z, val});
        }
    }
    string s;
    cin >> s;
    bool ref = false;
    int rot = 0;
    for (char c : s) {
        if (c == 'T') {
            ref = !ref;
        } else if (c == 'L') {
            rot += (ref ? -1 : +1);
        } else if (c == 'R') {
            rot += (ref ? +1 : -1);
        }
        rot = (rot % 6 + 6) % 6;
    }
    map<tuple<int,int,int>, int> new_mapa;
    for (auto c : cells) {
        if (ref) c = reflectT(c);
        c = rotateK(c, rot);
        new_mapa[{c.x, c.y, c.z}] = c.value;
    }
    for (int y = -R; y <= R; ++y) {
        int x_min = max(-R, -y - R);
        int x_max = min(R, -y + R);
        bool first = true;
        for (int x = x_min; x <= x_max; ++x) {
            int z = -x - y;
            if (!first) cout << ' ';
            cout << new_mapa[{x, y, z}];
            first = false;
        }
        cout << "\n";
    }

    return 0;
}
//Legion team