def find_min_shift(arr):
    n = len(arr)
    if n == 0:
        return 0
        
    arr2 = arr * 2
    i, j, k = 0, 1, 0
    
    while j < n and k < n:
        if arr2[i + k] == arr2[j + k]:
            k += 1
            continue
        elif arr2[i + k] > arr2[j + k]:
            i = j
            j += 1
        else:
            j += k + 1
        k = 0
        
    return i

def first_run(n, arr):
    min_shift = find_min_shift(arr)
    return (min_shift + 1) % n + 1

def second_run(k, total_players, arr):
    k0 = k - 1

    all_numbers = set(range(1, total_players + 1))
    visible_numbers = set(arr)
    missing_numbers = list(all_numbers - visible_numbers)

    if len(missing_numbers) == 1:
        return missing_numbers[0]
    
    for candidate in missing_numbers:
        full_arr = arr[:k0] + [candidate] + arr[k0:]
        
        min_shift = find_min_shift(full_arr)
        if (min_shift + 1) % total_players == k0:
            return candidate
    
    return missing_numbers[0]

first_line = input().strip()
second_line = input().strip()
third_line = input().strip()

if first_line == "0":
    n = int(second_line)
    arr = list(map(int, third_line.split()))
    result = first_run(n, arr)
    print(result)
else:
    k = int(first_line)
    total_players = int(second_line)
    arr = list(map(int, third_line.split()))
    result = second_run(k, total_players, arr)
    print(result)