#include <iostream>
#include <vector>
#include <cmath>

using namespace std;

int main() {
    int n;
    cin >> n;

    vector<long long> x(n), y(n);

    for (int i = 0; i < n; ++i) {
        cin >> x[i] >> y[i];
    }

    double mdist = -1;
    vector<long long> best(6);

    for (int i = 0; i < n; ++i) {
        for (int j = 0; j < n; ++j) {
            if (i == j) continue;

            long long a = x[j] - x[i], b = y[j] - y[i];

            long long mi = 3000000000;
            long long ma = -3000000000;
            for (size_t k = 0; k < n; ++k) {
                long long v = a * x[k] + b * y[k];
                if (v < mi) mi = v;
                if (v > ma) ma = v;
            }

            double dist = (a != 0 || b != 0) ? double(ma - mi) / (1. * hypot(a, b)) : 0.0;

            if (dist > mdist) {
                mdist = dist;
                long long c1 = -ma;
                long long c2 = -mi;
                if (c1 < c2) swap(c1, c2);
                if(abs(c1) == 0) c1 = 0;
                if(abs(c2) == 0) c2 = 0;
                best = { a, b, c1, a, b, c2 };
            }
        }
    }

    cout << best[0] << " " << best[1] << " " << best[2] << "\n";
    cout << best[3] << " " << best[4] << " " << best[5] << "\n";
    return 0;
}
