import jdk.dynalink.Operation;

import java.util.Scanner;
import java.util.concurrent.Callable;

import static java.lang.System.exit;
import static java.lang.System.setOut;

public class Main {
    static String piano = "";
    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);

        for (int i = 0; i < 7; i++) {
            piano += "ABCDEFG";
        }
        piano += "ABC";

        int amount = scanner.nextInt();

        for (int i = 0; i < amount; i++) {
            String str = scanner.next();

            if (str.length() == 1) {
                System.out.println("YES");
                continue;
            }

            boolean cadDoIt = false;
            int amounOctav;
            if (str.charAt(0) == 'A' || str.charAt(0) == 'B' || str.charAt(0) == 'C') {
                amounOctav = 8;
            } else {
                amounOctav = 7;
            }
            
            for (int curOctava = 0; curOctava < amounOctav; curOctava++) {

                int curIndex = 7 * curOctava + charToInt(str.charAt(0)) - 1;
                char curSimv = str.charAt(0);

                boolean localCan = true;

                for (int j = 1; j < str.length(); j++) {
                    char newSimv = str.charAt(j);

                    curIndex = check(curIndex, curSimv, newSimv);

                    curSimv = newSimv;
                    if (curIndex == -1) {
                        localCan = false;
                        break;
                    } else if (curIndex == -2) {
                        exit(2);
                    }
                }
                if (localCan) {
                    cadDoIt = true;
                    break;
                }
            }
            if (cadDoIt) {
                System.out.println("YES");
            } else {
                System.out.println("NO");
            }
        }
    }

    public static int check(int curIndex, char curSimv, char newSimv) {
        if (curSimv == newSimv) {
            return curIndex;
        }

        boolean isToRight = toRight(curSimv, newSimv);

        Operationable op = (int num1, int num2) ->  num1 - num2;
        ;

        if (isToRight) {
            op = (int num1, int num2) -> num1 + num2;
        }

        try {
            for (int i = 1; i < 4; i++) {
                if (piano.charAt(op.execute(curIndex, i)) == newSimv) {
                    return op.execute(curIndex, i);
                }
            }
        } catch (IndexOutOfBoundsException e) {
            return -1;
        }
        return -2;
    }

    public static boolean toRight(char ch1, char ch2) {
        int num1 = charToInt(ch1) - 1;
        int num2 = charToInt(ch2) - 1;

        int lenRightStep = (num2 - num1 + 7) % 7;

        return lenRightStep > 0 && lenRightStep <= 3;
    }

    public static int charToInt(char c) {
        return switch (c) {
            case 'A' -> 1;
            case 'B' -> 2;
            case 'C' -> 3;
            case 'D' -> 4;
            case 'E' -> 5;
            case 'F' -> 6;
            case 'G' -> 7;
            default -> -1;
        };
    }
}
interface Operationable {
    int execute(int x, int y);
}