#include <algorithm>
#include <bitset>
#include <cassert>
#include <cmath>
#include <cstdlib>
#include <deque>
#include <functional>
#include <iomanip>
#include <iostream>
#include <map>
#include <queue>
#include <set>
#include <stack>
#include <string>
#include <unordered_map>
#include <unordered_set>
#include <utility>
#include <vector>

using namespace std;

#define ll long long
#define uint unsigned int
#define ld long double
#define X first
#define Y second
#define all(a) (a).begin(), (a).end()
#define pii pair<int, int>
#define vii vector<pair<int, int>>
#define vvi vector<vector<int>>

#define DEBUG cout << "DEBUG "

int N = 52;

int get_step(char l, char r) {
  if (l == r) {
    return 0;
  }
  if (l < r) {
    return r - l <= 3 ? r - l : -(7 - (r - l));
  }
  return r - l >= -3 ? r - l : -(7 + r - l);
}

void solve() {
  string s;
  cin >> s;
  int cur = 0;
  int L = 0, R = 0;
  for (int i = 1; i < s.size(); ++i) {
    cur += get_step(s[i - 1], s[i]);
    R = max(R, cur);
    L = min(L, cur);
  }
  cout << ((R - L + 1 <= N) ? "YES\n" : "NO\n");
}

signed main() {
  int T;
  cin >> T;
  while (T--) {
    solve();
  }

  // DEBUG << "a -> b = " << get_step('a', 'b') << '\n';
  // DEBUG << "a -> c = " << get_step('a', 'c') << '\n';
  // DEBUG << "a -> d = " << get_step('a', 'd') << '\n';
  // DEBUG << "a -> e = " << get_step('a', 'e') << '\n';
  // DEBUG << "a -> f = " << get_step('a', 'f') << '\n';
  // DEBUG << "a -> g = " << get_step('a', 'g') << '\n';

  // DEBUG << "a <- b = " << get_step('b', 'a') << '\n';
  // DEBUG << "a <- c = " << get_step('c', 'a') << '\n';
  // DEBUG << "a <- d = " << get_step('d', 'a') << '\n';
  // DEBUG << "a <- e = " << get_step('e', 'a') << '\n';
  // DEBUG << "a <- f = " << get_step('f', 'a') << '\n';
  // DEBUG << "a <- g = " << get_step('g', 'a') << '\n';

  return 0;
}
