﻿#include <iostream>
#include <string>
#include <vector>
using namespace std;

const string notes = "ABCDEFG";
const int MAX_KEYS = 52;

char note_at(int pos) {
    return notes[pos % 7];
}

int main() {

    int t;
    cin >> t;
    vector<string> v;
    for (int i = 0; i < t; i++) {
        string s;
        cin >> s;
        v.push_back(s);
    }
    for (string note_sequence : v) {
        vector<int> current_positions;
        for (int pos = 0; pos < MAX_KEYS; pos++) {
            if (note_at(pos) == note_sequence[0]) {
                current_positions.push_back(pos);
            }
        }
        bool is_condition_true = true;
        for (size_t i = 1; i < note_sequence.size(); i++) {
            vector<int> next_positions;
            char target_note = note_sequence[i];
            for (int curr_pos : current_positions) {
                for (int delta = -3; delta <= 3; delta++) {
                    int new_pos = curr_pos + delta;
                    if (new_pos >= 0 && new_pos < MAX_KEYS &&
                        note_at(new_pos) == target_note) {
                        bool already_exists = false;
                        for (int pos : next_positions) {
                            if (pos == new_pos) {
                                already_exists = true;
                                break;
                            }
                        }
                        if (!already_exists) {
                            next_positions.push_back(new_pos);
                        }
                    }
                }
            }
            if (next_positions.empty()) {
                is_condition_true = false;
                break;
            }
            current_positions = next_positions;
        }
        if (is_condition_true) {
            cout << "YES" << endl;
        }
        else cout << "NO" << endl;
    }
    return 0;
}