﻿#include <bits/stdc++.h>
using namespace std;

const int MOD = 1e9 + 7;
const int MAX = 3000005;

int fac[MAX], inv_fac[MAX], inv[MAX];
int comb_precomputed[MAX];
int inv_comb_precomputed[MAX];

int mod_pow(int a, int b) {
    int res = 1;
    while (b) {
        if (b & 1) res = 1LL * res * a % MOD;
        a = 1LL * a * a % MOD;
        b >>= 1;
    }
    return res;
}

void precompute() {
    fac[0] = 1;
    for (int i = 1; i < MAX; i++) {
        fac[i] = 1LL * fac[i - 1] * i % MOD;
    }
    inv_fac[MAX - 1] = mod_pow(fac[MAX - 1], MOD - 2);
    for (int i = MAX - 2; i >= 0; i--) {
        inv_fac[i] = 1LL * inv_fac[i + 1] * (i + 1) % MOD;
    }

    for (int i = 1; i < MAX; i++) {
        inv[i] = mod_pow(i, MOD - 2);
    }
}

void precompute_comb(int n, int* comb_arr, int* inv_comb_arr, int max_k) {
    comb_arr[0] = 1;
    inv_comb_arr[0] = 1;

    for (int k = 1; k <= max_k; k++) {
        comb_arr[k] = 1LL * comb_arr[k - 1] * (n - k + 1) % MOD;
        comb_arr[k] = 1LL * comb_arr[k] * inv[k] % MOD;
        inv_comb_arr[k] = mod_pow(comb_arr[k], MOD - 2);
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    precompute();

    int t;
    cin >> t;

    vector<int> answers;
    answers.reserve(t);

    while (t--) {
        int p, m;
        cin >> p >> m;
        int N = 2 * p + m;
        int max_k = p + m;

        precompute_comb(N, comb_precomputed, inv_comb_precomputed, max_k);

        long long total = 0;

        int F0 = 1;
        int F1 = (2LL * p + m) % MOD;

        total = (total + 1LL * F0 * inv_comb_precomputed[0]) % MOD;

        if (max_k >= 1) {
            total = (total + 1LL * F1 * inv_comb_precomputed[1]) % MOD;
        }

        int F_prev2 = F0;
        int F_prev1 = F1;

        int A = (2LL * p + m) % MOD;
        int B = (2LL * p + 2LL * m) % MOD;

        for (int k = 2; k <= max_k; k++) {
            long long term1 = (A - 3LL * k + 3 + MOD) % MOD;
            long long term2 = (B - 2LL * k + 4 + MOD) % MOD;

            int Fk = (term1 * F_prev1 + term2 * F_prev2) % MOD;
            Fk = 1LL * Fk * inv[k] % MOD;

            total = (total + 1LL * Fk * inv_comb_precomputed[k]) % MOD;

            F_prev2 = F_prev1;
            F_prev1 = Fk;
        }

        answers.push_back(total % MOD);
    }

    for (int ans : answers) {
        cout << ans << "\n";
    }

    return 0;
}