import java.util.Scanner;

public class Main {
    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        int t = scanner.nextInt();
        scanner.nextLine();

        for (int i = 0; i < t; i++) {
            String melody = scanner.nextLine();
            if (canPlay(melody)) {
                System.out.println("Yes");
            } else {
                System.out.println("No");
            }
        }

        scanner.close();
    }

    private static boolean canPlay(String melody) {
        String piano = "ABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGAB";

        char firstNote = melody.charAt(0);

        for (int start = 0; start < piano.length(); start++) {
            if (piano.charAt(start) == firstNote) {
                if (checkPath(melody, piano, start)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean checkPath(String melody, String piano, int startPos) {
        int currentPos = startPos;

        for (int i = 1; i < melody.length(); i++) {
            char target = melody.charAt(i);
            boolean found = false;

            for (int delta = -3; delta <= 3; delta++) {
                int nextPos = currentPos + delta;
                if (nextPos >= 0 && nextPos < piano.length() && piano.charAt(nextPos) == target) {
                    currentPos = nextPos;
                    found = true;
                    break;
                }
            }

            if (!found) {
                return false;
            }
        }
        return true;
    }
}