import java.util.Scanner;

public class Main {
    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);
        int t = scanner.nextInt();
        scanner.nextLine();

        long[] noteMasks = new long[7];
        for (int i = 0; i < 52; i++) {
            int noteIndex = i % 7;
            noteMasks[noteIndex] |= (1L << i);
        }

        for (int i = 0; i < t; i++) {
            String melody = scanner.nextLine().trim();
            if (melody.isEmpty()) {
                System.out.println("Yes");
                continue;
            }
            System.out.println(canPlay(melody, noteMasks) ? "Yes" : "No");
        }
        scanner.close();
    }

    private static boolean canPlay(String melody, long[] noteMasks) {
        int n = melody.length();

        long currentMask = noteMasks[melody.charAt(0) - 'A'];

        for (int i = 1; i < n; i++) {
            int targetNote = melody.charAt(i) - 'A';
            long nextMask = 0;

            for (int pos = 0; pos < 52; pos++) {
                if ((currentMask & (1L << pos)) != 0) {
                    for (int offset = -3; offset <= 3; offset++) {
                        int nextPos = pos + offset;
                        if (nextPos >= 0 && nextPos < 52 && nextPos % 7 == targetNote) {
                            nextMask |= (1L << nextPos);
                        }
                    }
                }
            }

            if (nextMask == 0) {
                return false;
            }
            currentMask = nextMask;
        }

        return true;
    }
}