import sys

def first_run(n, a):
    next_arr = [x - 1 for x in a]
    visited = [False] * n
    
    min_in_cycle = n
    
    for i in range(n):
        if not visited[i]:
            current = i
            cycle = []
            while not visited[current]:
                visited[current] = True
                cycle.append(current)
                current = next_arr[current]
            
            cycle_min = min(cycle)
            if cycle_min < min_in_cycle:
                min_in_cycle = cycle_min

    print(min_in_cycle + 2)

def second_run(p, n, b):

    
    p0 = p - 1
    total_players = n + 1
    
    next_arr = [-1] * total_players
    
    current_idx = (p0 + 1) % total_players
    for num in b:
        next_arr[current_idx] = num - 1
        current_idx = (current_idx + 1) % total_players
    
    for x in range(1, total_players + 1):
        temp_next = next_arr.copy()
        temp_next[p0] = x - 1
        
        visited = [False] * total_players
        current = p0
        cycle_nodes = []
        
        while not visited[current]:
            visited[current] = True
            cycle_nodes.append(current)
            current = temp_next[current]
        
        if min(cycle_nodes) == p0:
            print(x)
            return

def main():
    launch_type = int(sys.stdin.readline())
    n = int(sys.stdin.readline())
    arr = list(map(int, sys.stdin.readline().split()))
    
    if launch_type == 0:
        first_run(n, arr)
    else:
        second_run(launch_type, n, arr)

if __name__ == "__main__":
    main()
