import java.util.*;

public class Main {
    public static void main(String[] args) {
        Scanner scanner = new Scanner(System.in);

        int runType = scanner.nextInt();
        int n = scanner.nextInt();
        int[] cards = new int[n];

        for (int i = 0; i < n; i++) {
            cards[i] = scanner.nextInt();
        }

        if (runType == 0) {
            handleFirstRun(cards, n);
        } else {
            handleSecondRun(runType, cards, n);
        }

        scanner.close();
    }

    private static void handleFirstRun(int[] cards, int n) {
        long expectedSum = (long) n * (n + 1) / 2;

        long actualSum = 0;
        for (int card : cards) {
            actualSum += card;
        }

        long diff = actualSum - expectedSum;

        int chosenPlayer = 1;

        if (diff != 0) {
            chosenPlayer = (int) ((Math.abs(diff) % n) + 1);
            if (chosenPlayer > n) chosenPlayer = n;
        }

        System.out.println(chosenPlayer);
    }

    private static void handleSecondRun(int chosenPlayer, int[] visibleCards, int n) {
        int[] freq = new int[n + 1];
        for (int card : visibleCards) {
            if (card >= 1 && card <= n) {
                freq[card]++;
            }
        }

        int myNumber = -1;

        for (int i = 1; i <= n; i++) {
            if (freq[i] == 0) {
                myNumber = i;
                break;
            }
        }

        if (myNumber == -1) {
            for (int i = 1; i <= n; i++) {
                if (freq[i] == 1) {
                    myNumber = i;
                    break;
                }
            }
        }
        if (myNumber == -1) {
            myNumber = chosenPlayer;
        }

        System.out.println(myNumber);
    }
}