def pianist(s):
    def octaves(ch):
        if ch in "ABC":
            return list(range(1, 9))
        else:
            return list(range(1, 8))

    def position(ch, octave):
        offset = {'A':1, 'B':2, 'C':3, 'D':4, 'E':5, 'F':6, 'G':7}
        return (octave - 1) * 7 + offset[ch]

    current_octaves = set(octaves(s[0]))
    
    for i in range(1, len(s)):
        prev_ch = s[i-1]
        curr_ch = s[i]
        next_octaves = set()
        
        for curr_oct in octaves(curr_ch):
            for prev_oct in current_octaves:
                if abs(position(curr_ch, curr_oct) - position(prev_ch, prev_oct)) <= 3:
                    next_octaves.add(curr_oct)
                    break  
        
        if not next_octaves:
            return "No"
        current_octaves = next_octaves
    
    return "Yes"

t = int(input())
for _ in range(t):
    vvod = input().strip()
    print(pianist(vvod))
