def pianist(s):
    offset = {'A':1, 'B':2, 'C':3, 'D':4, 'E':5, 'F':6, 'G':7}
    
    min_oct, max_oct = (1, 8) if s[0] in "ABC" else (1, 7)
    
    for i in range(1, len(s)):
        prev_ch, curr_ch = s[i-1], s[i]
        curr_min, curr_max = (1, 8) if curr_ch in "ABC" else (1, 7)
        
        new_min, new_max = float('inf'), -float('inf')
        found = False
        
        for curr_oct in range(curr_min, curr_max + 1):
            curr_pos = (curr_oct - 1) * 7 + offset[curr_ch]
            
            for prev_oct in range(min_oct, max_oct + 1):
                prev_pos = (prev_oct - 1) * 7 + offset[prev_ch]
                if abs(curr_pos - prev_pos) <= 3:
                    new_min = min(new_min, curr_oct)
                    new_max = max(new_max, curr_oct)
                    found = True
                    break
        
        if not found:
            return "No"
        
        min_oct, max_oct = new_min, new_max
    
    return "Yes"

t = int(input())
for _ in range(t):
    print(pianist(input().strip()))
