import sys

def read_hex(n):
    hex_grid = []
    for i in range(2 * n - 1):
        line = sys.stdin.readline().strip()
        nums = list(map(int, line.split()))
        hex_grid.append(nums)
    return hex_grid

def get_length(n, i):
    if i < n:
        return n + i
    else:
        return 3 * n - 2 - i

def rotate_60_clockwise(n, grid):
    new_grid = [[0] * get_length(n, i) for i in range(2 * n - 1)]
    
    for r in range(2 * n - 1):
        for c in range(len(grid[r])):
            if r < n:
                new_r = n - 1 + c
                new_c = n - 1 - r
            else:
                new_r = n - 1 + c
                new_c = 2 * n - 2 - r
            new_grid[new_r][new_c] = grid[r][c]
    
    return new_grid

def rotate_60_counterclockwise(n, grid):
    temp = grid
    for _ in range(5):
        temp = rotate_60_clockwise(n, temp)
    return temp

def flip_vertical(n, grid):
    new_grid = []
    for i in range(2 * n - 1):
        row = grid[i][:]
        row.reverse()
        new_grid.append(row)
    return new_grid

def apply_operations_optimized(n, grid, operations):
    rotation = 0
    flipped = False
    
    for op in operations:
        if op == 'R':
            rotation = (rotation + 1) % 6
        elif op == 'L':
            rotation = (rotation + 5) % 6
        elif op == 'T':
            if flipped:
                rotation = (6 - rotation) % 6
            flipped = not flipped
    
    result = grid
    if flipped:
        result = flip_vertical(n, result)
    
    for _ in range(rotation):
        result = rotate_60_clockwise(n, result)
    
    return result

def main():
    input_data = sys.stdin.read().splitlines()
    if not input_data:
        return
    
    n = int(input_data[0])
    
    hex_lines = []
    for i in range(1, 2 * n):
        if i >= len(input_data):
            break
        line = input_data[i].strip()
        if not line:
            continue
        nums = list(map(int, line.split()))
        hex_lines.append(nums)
    
    ops = ""
    if 2 * n < len(input_data):
        ops = input_data[2 * n].strip()
    
    result = apply_operations_optimized(n, hex_lines, ops)
    
    for row in result:
        print(' '.join(map(str, row)))

if __name__ == "__main__":
    main()
