#include <iostream>
#include <vector>
#include <cctype>
#include <string>
using namespace std;

int main() {
    vector<char> keys(52);
    string notes = "ABCDEFG";
    for (int i = 0; i < 52; ++i) {
        keys[i] = notes[i % 7];
    }

    vector<vector<int>> positions(256);
    for (int i = 0; i < 52; ++i) {
        positions[keys[i]].push_back(i);
    }

    int t;
    cin >> t;
    cin.ignore();

    while (t--) {
        string s;
        getline(cin, s);

        if (s.empty()) {
            cout << "Yes\n";
            continue;
        }

        vector<bool> possible(52, false);

        
        char first = s[0];
        for (int pos : positions[first]) {
            possible[pos] = true;
        }

        bool ok = true;
        for (int idx = 1; idx < s.size(); ++idx) {
            char note = s[idx];
            vector<bool> next_possible(52, false);
            bool found = false;

            for (int prev = 0; prev < 52; ++prev) {
                if (!possible[prev]) continue;
                for (int next_pos : positions[note]) {
                    if (abs(next_pos - prev) <= 3) {
                        next_possible[next_pos] = true;
                        found = true;
                    }
                }
            }

            if (!found) {
                ok = false;
                break;
            }
            possible = move(next_possible);
        }

        if (ok) {
            cout << "Yes\n";
        } else {
            cout << "No\n";
        }
    }

    return 0;
}