﻿#include <iostream>
#include <vector>
#include <string>
#include <algorithm>

using namespace std;

int T_mat[3][3] = { {0, 0, 1}, {0, 1, 0}, {1, 0, 0} };
int R_mat[3][3] = { {0, -1, 0}, {0, 0, -1}, {-1, 0, 0} };
int L_mat[3][3] = { {0, 0, -1}, {-1, 0, 0}, {0, -1, 0} };
int I_mat[3][3] = { {1, 0, 0}, {0, 1, 0}, {0, 0, 1} };

void multiply(int A[3][3], int B[3][3], int result[3][3]) {
    int temp[3][3] = { 0 };
    for (int i = 0; i < 3; i++) {
        for (int k = 0; k < 3; k++) {
            for (int j = 0; j < 3; j++) {
                temp[i][k] += A[i][j] * B[j][k];
            }
        }
    }
    for (int i = 0; i < 3; i++) {
        for (int j = 0; j < 3; j++) {
            result[i][j] = temp[i][j];
        }
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    int n;
    cin >> n;
    vector<vector<int>> input(2 * n - 1);
    for (int i = 0; i < 2 * n - 1; i++) {
        int count = (i < n) ? n + i : 3 * n - 2 - i;
        input[i].resize(count);
        for (int j = 0; j < count; j++) {
            cin >> input[i][j];
        }
    }

    string operations;
    cin >> operations;

    int M[3][3] = { {1, 0, 0}, {0, 1, 0}, {0, 0, 1} };

    for (char op : operations) {
        if (op == 'T') {
            multiply(M, T_mat, M);
        }
        else if (op == 'R') {
            multiply(M, L_mat, M);
        }
        else if (op == 'L') {
            multiply(M, R_mat, M);
        }
    }

    vector<vector<int>> output(2 * n - 1);
    for (int i = 0; i < 2 * n - 1; i++) {
        int count = (i < n) ? n + i : 3 * n - 2 - i;
        output[i].resize(count);
        for (int j = 0; j < count; j++) {
            int y = i - (n - 1);
            int L_val = max(-(n - 1), -i);
            int x = L_val + j;
            int z = -x - y;

            int x0 = M[0][0] * x + M[0][1] * y + M[0][2] * z;
            int y0 = M[1][0] * x + M[1][1] * y + M[1][2] * z;
            int z0 = M[2][0] * x + M[2][1] * y + M[2][2] * z;

            int i0 = y0 + (n - 1);
            int L0 = max(-(n - 1), -i0);
            int j0 = x0 - L0;

            output[i][j] = input[i0][j0];
        }
    }

    for (int i = 0; i < 2 * n - 1; i++) {
        for (int j = 0; j < output[i].size(); j++) {
            if (j > 0) {
                cout << " ";
            }
            cout << output[i][j];
        }
        cout << "\n";
    }

    return 0;
}