﻿#include <iostream>
#include <string>
#include <numeric>

int get_mod3(const std::string& x) {
    long long sum_digits = 0;
    for (char c : x) {
        sum_digits += (c - '0');
    }
    return sum_digits % 3;
}

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);

    int t;
    std::cin >> t;

    for (int i = 0; i < t; ++i) {
        std::string x;
        std::cin >> x;

        while (x != "1") {
            if (x == "0") {
                return 0;
            }

            char last_digit = x.back();
            if (last_digit == '0' || last_digit == '2' || last_digit == '4' || last_digit == '6' || last_digit == '8') {
                std::cout << "collatz\n";
            }
            else {
                int mod3 = get_mod3(x);

                if (mod3 != 0) {
                    std::cout << "collatz\n";
                }
                else {
                    if (x.length() < 3) {
                        std::cout << "random\n";
                    }
                    else {
                        std::cout << "collatz\n";
                    }
                }
            }

            std::cout.flush();
            std::cin >> x;
        }
    }
    return 0;
}