﻿#include <iostream>
#include <vector>
#include <numeric>
#include <algorithm>

const int MAX_VAL = 999983;
const int MAX_SUM = 2 * MAX_VAL;

const int MOD = 998244353;
const int ROOT = 3;
const int MAX_FFT_SIZE = 1 << 21;

long long power(long long base, long long exp) {
    long long res = 1;
    base %= MOD;
    while (exp > 0) {
        if (exp % 2 == 1) res = (res * base) % MOD;
        base = (base * base) % MOD;
        exp /= 2;
    }
    return res;
}

long long modInverse(long long n) {
    return power(n, MOD - 2);
}

void ntt(std::vector<long long>& a, bool invert) {
    int n = a.size();

    for (int i = 1, j = 0; i < n; i++) {
        int bit = n >> 1;
        for (; j & bit; bit >>= 1)
            j ^= bit;
        j ^= bit;
        if (i < j)
            std::swap(a[i], a[j]);
    }

    for (int len = 2; len <= n; len <<= 1) {
        long long wlen = power(ROOT, (MOD - 1) / len);
        if (invert)
            wlen = modInverse(wlen);
        for (int i = 0; i < n; i += len) {
            long long w = 1;
            for (int j = 0; j < len / 2; j++) {
                long long u = a[i + j], v = (a[i + j + len / 2] * w) % MOD;
                a[i + j] = (u + v) % MOD;
                a[i + j + len / 2] = (u - v + MOD) % MOD;
                w = (w * wlen) % MOD;
            }
        }
    }

    if (invert) {
        long long n_inv = modInverse(n);
        for (long long& x : a)
            x = (x * n_inv) % MOD;
    }
}

bool v_exists[MAX_VAL];
std::vector<int> v_elements;

bool p_base[MAX_SUM + 1];

std::vector<int> u_elements;
bool p_u[MAX_SUM + 1];

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);

    int n;
    long long s;
    std::cin >> n >> s;

    const int BLOCK_SIZE = 2048;

    for (int i = 0; i < n; i += BLOCK_SIZE) {
        if (!v_elements.empty()) {
            std::vector<long long> p_v(MAX_FFT_SIZE, 0);
            for (int val : v_elements) {
                p_v[val] = 1;
            }
            ntt(p_v, false);
            for (int k = 0; k < MAX_FFT_SIZE; ++k) {
                p_v[k] = (p_v[k] * p_v[k]) % MOD;
            }
            ntt(p_v, true);

            for (int k = 0; k <= MAX_SUM; ++k) {
                long long c_s = p_v[k];
                int k_s;
                if (k % 2 != 0) {
                    k_s = (c_s * modInverse(2)) % MOD;
                }
                else {
                    long long term = (k / 2 < MAX_VAL && v_exists[k / 2]) ? 1 : 0;
                    k_s = ((c_s - term + MOD) % MOD * modInverse(2) + term) % MOD;
                }
                p_base[k] = (k_s % 2 == 0);
            }
        }
        else {
            for (int k = 0; k <= MAX_SUM; ++k) p_base[k] = true;
        }

        u_elements.clear();
        std::fill(p_u, p_u + MAX_SUM + 1, true);

        int current_block_size = std::min(BLOCK_SIZE, n - i);
        for (int j = 0; j < current_block_size; ++j) {
            s = (s * 618023 + 1) % MAX_VAL;

            bool par_v = p_base[s];
            bool par_u = p_u[s];

            bool par_cross = true;
            for (int u_val : u_elements) {
                long long diff = s - u_val;
                if (diff >= 0 && diff < MAX_VAL && v_exists[diff]) {
                    par_cross = !par_cross;
                }
            }

            if (par_v == par_u && par_v == par_cross) {
                if (!v_exists[s] && std::find(u_elements.begin(), u_elements.end(), static_cast<int>(s)) == u_elements.end()) {
                    for (int u_old : u_elements) {
                        p_u[s + u_old] = !p_u[s + u_old];
                    }
                    if (2 * s <= MAX_SUM) {
                        p_u[2 * s] = !p_u[2 * s];
                    }
                    u_elements.push_back(s);
                }
            }
        }

        for (int u_val : u_elements) {
            if (!v_exists[u_val]) {
                v_exists[u_val] = true;
                v_elements.push_back(u_val);
            }
        }
    }

    std::cout << v_elements.size() << std::endl;

    return 0;
}