﻿#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

const int P = 998244353;
const int G = 3;
const int MAX_L = 1 << 21;

long long pow_mod(long long base, long long exp) {
    long long res = 1;
    base %= P;
    while (exp > 0) {
        if (exp % 2 == 1) res = (res * base) % P;
        base = (base * base) % P;
        exp /= 2;
    }
    return res;
}

long long inv_mod(long long n) {
    return pow_mod(n, P - 2);
}

void ntt(vector<int>& poly, int L, bool inverse) {
    for (int i = 0, j = 0; i < L; i++) {
        if (i < j) swap(poly[i], poly[j]);
        int mask = L >> 1;
        while (j & mask) {
            j &= ~mask;
            mask >>= 1;
        }
        j |= mask;
    }

    for (int len = 2; len <= L; len <<= 1) {
        int half = len >> 1;
        long long wn = pow_mod(G, (P - 1) / len);
        if (inverse) wn = inv_mod(wn);

        for (int i = 0; i < L; i += len) {
            long long w = 1;
            for (int j = 0; j < half; j++) {
                long long u = poly[i + j];
                long long v = (poly[i + j + half] * w) % P;
                poly[i + j] = (u + v) % P;
                poly[i + j + half] = (u - v + P) % P;
                w = (w * wn) % P;
            }
        }
    }

    if (inverse) {
        long long inv_L = inv_mod(L);
        for (int& x : poly) {
            x = (x * inv_L) % P;
        }
    }
}

void solve() {
    int n;
    long long s_val;
    cin >> n >> s_val;

    const long long MOD_S = 999983;

    vector<bool> present(MOD_S, false);

    vector<int> V_elements;

    vector<int> A(MAX_L, 0);
    vector<int> C(MAX_L);

    for (int step = 0; step < n; ++step) {
        s_val = (s_val * 618023 + 1) % MOD_S;
        int s = (int)s_val;

        long long C_prime = 0;
        if (s < MAX_L) {
            C_prime = C[s];
        }

        long long count_equal_parts = 0;
        if (s % 2 == 0) {
            int half_s = s / 2;
            if (half_s < MOD_S && present[half_s]) {
                count_equal_parts = 1;
            }
        }

        long long C_total = (C_prime + count_equal_parts);

        if (C_total % 2 == 0) {
            if (!present[s]) {
                present[s] = true;
                V_elements.push_back(s);

                if (s < MAX_L) {
                    A[s] = 1;
                }

                vector<int> A_ntt = A;
                ntt(A_ntt, MAX_L, false);

                for (int i = 0; i < MAX_L; ++i) {
                    C[i] = (long long)A_ntt[i] * A_ntt[i] % P;
                }

                ntt(C, MAX_L, true);
            }
        }
    }

    cout << V_elements.size() << endl;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    solve();

    return 0;
}