﻿#include <iostream>
#include <vector>
#include <cstdint>
#include <algorithm>

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    const int MOD = 999983;
    const int A = 618023;

    int n, s;
    cin >> n >> s;

    vector<uint8_t> present(MOD, 0);
    vector<int> elements;
    elements.reserve(3000);

    for (int i = 0; i < n; ++i) {
        s = int(((int64_t)s * A + 1) % MOD);

        bool parity = false;
        for (int a : elements) {
            int b = s - a;
            if (b < 0) continue;
            if (b >= MOD) break;
            if (present[b]) parity = !parity;
        }

        if (!parity && !present[s]) {
            present[s] = 1;
            elements.push_back(s);
            sort(elements.begin(), elements.end());
        }
    }

    cout << elements.size() << '\n';
    return 0;
}
