﻿#include <iostream>
#include <vector>

using ll = long long;

const int MOD = 1e9 + 7;
const int MAX_P = 1e6;
const int MAX_FACT = 2 * MAX_P;

std::vector<ll> fact(MAX_FACT + 1);
std::vector<ll> invFact(MAX_FACT + 1);

ll power(ll base, ll exp) {
    ll res = 1;
    base %= MOD;
    while (exp > 0) {
        if (exp % 2 == 1) res = (res * base) % MOD;
        base = (base * base) % MOD;
        exp /= 2;
    }
    return res;
}

ll modInverse(ll n) {
    return power(n, MOD - 2);
}

void precompute_factorials() {
    fact[0] = 1;
    invFact[0] = 1;
    for (int i = 1; i <= MAX_FACT; i++) {
        fact[i] = (fact[i - 1] * i) % MOD;
    }
    invFact[MAX_FACT] = modInverse(fact[MAX_FACT]);
    for (int i = MAX_FACT - 1; i >= 1; i--) {
        invFact[i] = (invFact[i + 1] * (i + 1)) % MOD;
    }
}

void solve() {
    int p, m;
    std::cin >> p >> m;

    ll C_2p_p = fact[2 * p];
    C_2p_p = (C_2p_p * invFact[p]) % MOD;
    C_2p_p = (C_2p_p * invFact[p]) % MOD;

    ll pow4_p = power(4, p);

    ll E_p0 = (pow4_p * modInverse(C_2p_p)) % MOD;

    ll num = 2LL * p + m + 1;
    ll den = 2LL * p + 1;

    ll E_pm = (E_p0 * num) % MOD;
    E_pm = (E_pm * modInverse(den)) % MOD;

    std::cout << E_pm << "\n";
}

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);

    precompute_factorials();

    int t;
    std::cin >> t;
    while (t--) {
        solve();
    }

    return 0;
}