#include <iostream>
#include <vector>
#include <algorithm>
#include <climits>

using namespace std;

int main() {
    int n;
    cin >> n;

    vector<long long> lengths(n);
    long long total_sum = 0;

    for (int i = 0; i < n; i++) {
        cin >> lengths[i];
        total_sum += lengths[i];
    }

    long long min_area = LLONG_MAX;
    long long max_area = 0;

    // Перебираем все возможные разбиения с помощью битовой маски
    // mask от 1 до (2^n - 2), чтобы обе группы были непустыми
    int total_masks = (1 << n);

    for (int mask = 1; mask < total_masks - 1; mask++) {
        long long side1 = 0;
        long long side2 = 0;

        for (int i = 0; i < n; i++) {
            if (mask & (1 << i)) {
                side1 += lengths[i];
            } else {
                side2 += lengths[i];
            }
        }

        long long area = side1 * side2;
        min_area = min(min_area, area);
        max_area = max(max_area, area);
    }

    cout << min_area << " " << max_area << endl;

    return 0;
}