def build_layout():
    letters = "ABCDEFG"
    layout = [letters[i % 7] for i in range(52)]
    pos = {ch: [] for ch in letters}
    for i, ch in enumerate(layout):
        pos[ch].append(i)
    return pos

POS = build_layout()

def playable(s: str) -> bool:
    s = s.strip().upper()
    if not s:
        return True
    active = [False] * 52
    for i in POS[s[0]]:
        active[i] = True
    for ch in s[1:]:
        nxt = [False] * 52
        for j in POS[ch]:
            lo = max(0, j - 3)
            hi = min(51, j + 3)
            for k in range(lo, hi + 1):
                if active[k]:
                    nxt[j] = True
                    break
        active = nxt
        if not any(active):
            return False
    return any(active)

def solve():
    t = int(input())
    out = []
    for i in range(t):
        data = input()
        out.append("YES" if playable(data) else "NO")
    print("\n".join(out))

if __name__ == "__main__":
    solve()
