from math import sqrt, gcd

n = int(input())
points = []
for _ in range(n):
    x, y = map(int, input().split())
    points.append((x, y))

max_width = -1
best_result = None

normals = set()

for i in range(n):
    for j in range(i + 1, n):
        dx = points[j][0] - points[i][0]
        dy = points[j][1] - points[i][1]
        
        g = gcd(abs(dx), abs(dy))
        if g > 0:
            dx, dy = dx // g, dy // g
        
        normals.add((dx, dy))
        normals.add((-dy, dx))

for a, b in normals:
    if a == 0 and b == 0:
        continue
    
    values = [a * p[0] + b * p[1] for p in points]
    min_val = min(values)
    max_val = max(values)
    
    width = (max_val - min_val) / sqrt(a * a + b * b)
    
    if width > max_width:
        max_width = width
        c1 = -min_val
        c2 = -max_val
        
        g = gcd(gcd(abs(a), abs(b)), abs(c1)) if c1 != 0 else gcd(abs(a), abs(b))
        if g > 0:
            a1, b1, c1 = a // g, b // g, c1 // g
        else:
            a1, b1, c1 = a, b, c1
        
        g = gcd(gcd(abs(a), abs(b)), abs(c2)) if c2 != 0 else gcd(abs(a), abs(b))
        if g > 0:
            a2, b2, c2 = a // g, b // g, c2 // g
        else:
            a2, b2, c2 = a, b, c2
        
        best_result = [(a1, b1, c1), (a2, b2, c2)]

for a, b, c in best_result:
    print(a, b, c)