#include <iostream>
#include <vector>
#include <string>
#include <array>
#include <unordered_map>
#include <algorithm>
#include <sstream>
#include <iomanip>

int main() {
    std::ios::sync_with_stdio(false);
    std::cin.tie(nullptr);

    int n;
    std::cin >> n;
    int R = n - 1;

    std::vector<std::vector<int>> grid(2 * n - 1);
    std::string line;
    
    std::getline(std::cin, line);
    
    for (int i = 0; i < 2 * n - 1; i++) {
        std::getline(std::cin, line);
        std::istringstream ss(line);
        int num;
        while (ss >> num) {
            grid[i].push_back(num);
        }
    }

    std::string ops;
    std::getline(std::cin, ops);

    std::vector<std::array<int, 3>> coords;
    for (int z = -R; z <= R; z++) {
        int xmin = std::max(-R, -z - R);
        int xmax = std::min(R, -z + R);
        for (int x = xmin; x <= xmax; x++) {
            int y = -x - z;
            coords.push_back({x, y, z});
        }
    }

    auto rotate_cw = [](int &x, int &y, int &z) {
        int nx = -z, ny = -x, nz = -y;
        x = nx; y = ny; z = nz;
    };
    
    auto rotate_ccw = [](int &x, int &y, int &z) {
        int nx = -y, ny = -z, nz = -x;
        x = nx; y = ny; z = nz;
    };
    
    auto reflect = [](int &x, int &y, int &z) {
        std::swap(x, y);
    };

    for (char op : ops) {
        if (op == 'R') {
            for (auto &cell : coords) {
                rotate_cw(cell[0], cell[1], cell[2]);
            }
        } else if (op == 'L') {
            for (auto &cell : coords) {
                rotate_ccw(cell[0], cell[1], cell[2]);
            }
        } else if (op == 'T') {
            for (auto &cell : coords) {
                reflect(cell[0], cell[1], cell[2]);
            }
        }
    }

    std::unordered_map<long long, int> original_map;
    int idx = 0;
    for (int z = -R; z <= R; z++) {
        int xmin = std::max(-R, -z - R);
        int xmax = std::min(R, -z + R);
        int row_idx = z + R;
        for (int x = xmin; x <= xmax; x++) {
            int y = -x - z;
            long long key = (x + 1000LL) * 1000000LL + (y + 1000LL) * 1000LL + (z + 1000LL);
            original_map[key] = grid[row_idx][x - xmin];
            idx++;
        }
    }

    std::vector<std::vector<int>> result(2 * n - 1);
    idx = 0;
    for (int z = -R; z <= R; z++) {
        int xmin = std::max(-R, -z - R);
        int xmax = std::min(R, -z + R);
        for (int x = xmin; x <= xmax; x++) {
            std::array<int, 3> cell = coords[idx];
            int tx = cell[0], ty = cell[1], tz = cell[2];
            long long key = (tx + 1000LL) * 1000000LL + (ty + 1000LL) * 1000LL + (tz + 1000LL);
            result[z + R].push_back(original_map[key]);
            idx++;
        }
    }

    for (const auto &row : result) {
        int spaces_before = (2 * n - 1 - row.size());
        for (int i = 0; i < spaces_before; i++) {
            std::cout << " ";
        }
        
        for (size_t i = 0; i < row.size(); i++) {
            if (i > 0) std::cout << " ";
            std::cout << std::setw(2) << row[i];
        }
        std::cout << '\n';
    }

    return 0;
}