#include <iostream>
#include <cmath>
using namespace std;

// Проверяем, есть ли степень двойки в диапазоне [min_r, max_r]
bool has_power_of_two(long long min_r, long long max_r) {
    long long p = 1;
    while (p < min_r) p <<= 1;
    return p <= max_r;
}

// Решение
int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    cin >> t;

    while (t--) {
        long long x;
        cin >> x;

        while (x > 1) {
            if (x == 0) return 0;

            // Эвристика: пробуем random, если x нечётное и диапазон [3x+1;6x]
            // содержит степень двойки — ИЛИ если x слишком велик
            if (x % 2 == 1) {
                long long min_r = 3LL * x + 1;
                long long max_r = 6LL * x;
                if (has_power_of_two(min_r, max_r) || x > 1000000) {
                    cout << "random\n";
                    cout.flush();
                    cin >> x;
                    continue;
                }
            }

            // иначе — обычный collatz
            cout << "collatz\n";
            cout.flush();
            cin >> x;
        }
    }
    return 0;
}
