#include <bits/stdc++.h>
using namespace std;

int count_twos(long long x) {
    int count = 0;
    while (x % 2 == 0) {
        x /= 2;
        count++;
    }
    return count;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int t;
    cin >> t;
    
    mt19937 rng(12345);
    
    while (t--) {
        string x;
        cin >> x;
        
        while (x != "1" && x != "0") {
            bool use_random = false;
            
            // Try to parse as number if small enough
            if (x.length() <= 18) {
                long long num = 0;
                for (char c : x) {
                    num = num * 10 + (c - '0');
                }
                
                // Check if odd
                if (num % 2 == 1) {
                    // Check how many factors of 2 in 3*num+1
                    long long val_3x1 = 3*num + 1;
                    int divs_collatz = count_twos(val_3x1);
                    
                    // If only 1 factor of 2, try random
                    if (divs_collatz == 1 && x.length() <= 2) {
                        // For small odd numbers with bad collatz,
                        // use random with some probability
                        use_random = (rng() % 100 < 20);
                    }
                    // Special case for numbers like 27 or 3
                    else if (divs_collatz <= 2 && num < 100) {
                        use_random = (rng() % 100 < 15);
                    }
                }
            }
            
            cout << (use_random ? "random" : "collatz") << endl;
            cout.flush();
            
            cin >> x;
        }
        
        if (x == "0") return 0;
    }
    
    return 0;
}