def should_use_random(x: int) -> bool:
    if x % 2 == 0:
        return False
    
    min_r = 3 * x + 1
    max_r = 6 * x
    pow2 = 1
    while pow2 <= max_r:
        if pow2 >= min_r:
            return True
        pow2 <<= 1
    
    if x > 10000:
        return True
    
    return False


def main():
    t = int(input())
    for _ in range(t):
        x = int(input())
        
        while x > 1:
            while x > 1 and x % 2 == 0:
                print("collatz", flush=True)
                x = int(input())
                if x == 0:
                    return
            
            if x <= 1:
                break
            if should_use_random(x):
                print("random", flush=True)
                x = int(input())
                if x == 0:
                    return
                if x == 1:
                    break
            else:
                print("collatz", flush=True)
                x = int(input())
                if x == 0:
                    return
                if x == 1:
                    break


if __name__ == "__main__":
    main()
