# ICPC NW 2025-2026 — Problem M: "Sums of Two"

def main():
    n, s = map(int, input().split())
    MOD = 999_983
    A = 618_023
    MASK = (1 << MOD) - 1  # limit bitsets to [0..MOD-1]

    B = 0      # presence bitset of V
    c1 = 0     # second bit of C[s] modulo 4 (parity of off-diagonal pairs)
    size = 0   # |V|

    for _ in range(n):
        s = (s * A + 1) % MOD

        # parity of number of unordered pairs for sum s:
        diag = 1 if (s % 2 == 0 and ((B >> (s // 2)) & 1)) else 0   # D[s]
        off  = (c1 >> s) & 1                                       # second bit of C[s]
        parity = diag ^ off

        if parity == 0:
            # add s to V only if it's not already there
            if ((B >> s) & 1) == 0:
                c1 ^= (B << s) & MASK  # add 2 for all sums x+y=s (toggle second bit)
                B |= (1 << s)          # insert s
                size += 1

    print(size)

if __name__ == "__main__":
    main()
