#include <iostream>
#include <vector>
#include <map>
#include <numeric>  // Добавить этот заголовок
using namespace std;

const long long MOD = 1000000007;

long long gcd(long long a, long long b, long long &x, long long &y) {
    if (a == 0) {
        x = 0; y = 1;
        return b;
    }
    long long x1, y1;
    long long g = gcd(b % a, a, x1, y1);
    x = y1 - (b / a) * x1;
    y = x1;
    return g;
}

long long modinv(long long a) {
    long long x, y;
    gcd(a, MOD, x, y);
    return (x % MOD + MOD) % MOD;
}

struct Frac {
    long long num, den;

    Frac(long long n = 0, long long d = 1) {
        if (d < 0) { n = -n; d = -d; }
        long long g = std::gcd(abs(n), abs(d));  // Изменить сюда
        num = n / g;
        den = d / g;
    }

    Frac operator+(const Frac &f) const {
        return Frac(num * f.den + f.num * den, den * f.den);
    }

    Frac operator*(const Frac &f) const {
        return Frac(num * f.num, den * f.den);
    }

    long long toMod() const {
        return (num % MOD * modinv(den % MOD)) % MOD;
    }
};

// Остальной код без изменений
int p, m, total;
map<pair<int,int>, Frac> memo;

Frac solve(int pairs_hand, int singles_hand) {
    if (memo.count({pairs_hand, singles_hand}))
        return memo[{pairs_hand, singles_hand}];

    int remaining = total - pairs_hand - singles_hand;

    if (remaining == 0)
        return Frac(0);

    int match_socks = pairs_hand;
    int new_pair_socks = 2 * p - 2 * pairs_hand;
    int new_single_socks = m - singles_hand;

    Frac exp = Frac(1);

    if (new_pair_socks > 0) {
        exp = exp + Frac(new_pair_socks, remaining) * solve(pairs_hand + 1, singles_hand);
    }
    if (new_single_socks > 0) {
        exp = exp + Frac(new_single_socks, remaining) * solve(pairs_hand, singles_hand + 1);
    }

    return memo[{pairs_hand, singles_hand}] = exp;
}

int main() {
    int t;
    cin >> t;

    while (t--) {
        cin >> p >> m;
        total = 2 * p + m;
        memo.clear();

        Frac result = solve(0, 0);
        cout << result.toMod() << endl;
    }

    return 0;
}
