#include <iostream>
#include <vector>
#include <unordered_set>

int main() {
    std::ios::sync_with_stdio(false);
    std::cin.tie(nullptr);

    long long n, s;
    std::cin >> n >> s;

    std::vector<long long> V;
    std::unordered_set<long long> present;
    V.reserve(n);

    for (long long i = 0; i < n; ++i) {
        s = (s * 618023 + 1) % 999983;

        long long hits = 0;
        for (long long x : V) {
            if (present.find(s - x) != present.end()) {
                ++hits;
            }
        }

        long long count = hits / 2;

        if ((count & 1) == 0) {
            V.push_back(s);
            present.insert(s);
        }
    }

    std::cout << V.size() << '\n';
    return 0;
}