import sys

MOD = 10 ** 9 + 7
MAX = 3_000_000 + 10
fact = [1] * MAX
for i in range(1, MAX):
    fact[i] = fact[i - 1] * i % MOD

inv_fact = [1] * MAX
inv_fact[MAX - 1] = pow(fact[MAX - 1], MOD - 2, MOD)
for i in range(MAX - 2, -1, -1):
    inv_fact[i] = inv_fact[i + 1] * (i + 1) % MOD

def nCr(n, k):
    if k < 0 or k > n:
        return 0
    return fact[n] * inv_fact[k] % MOD * inv_fact[n - k] % MOD

pow2 = [1] * MAX
for i in range(1, MAX):
    pow2[i] = (pow2[i - 1] * 2) % MOD

data = sys.stdin.read().split()
t = int(data[0])
index = 1
out_lines = []
for _ in range(t):
    p = int(data[index]);
    m = int(data[index + 1]);
    index += 2
    n = 2 * p + m
    max_k = p + m
    total = 0
    for k in range(0, max_k + 1):
        i_min = max(0, k - m)
        i_max = min(k, p)
        num = 0
        for i in range(i_min, i_max + 1):
            term = nCr(p, i) * pow2[i] % MOD
            term = term * nCr(m, k - i) % MOD
            num = (num + term) % MOD
        den = nCr(n, k)
        if den == 0:
            continue
        inv_den = pow(den, MOD - 2, MOD)
        S_k = num * inv_den % MOD
        total = (total + S_k) % MOD
    out_lines.append(str(total))
sys.stdout.write("\n".join(out_lines))
