#include <algorithm>
#include <iostream>
#include <string>
#include <unordered_map>
#include <vector>

typedef unsigned long long ull;
typedef long long ll;

const ll INF = 1e18;
const int MOD = 1e9 + 7;

static constexpr auto printVec = [](std::ostream& out, const auto& v) {
  out << "[ ";
  for (const auto& val : v) {
    out << val << " ";
  }
  out << "]\n";
};

ll mod_add(ll a, ll b, ll m = MOD) { return ((a % m) + (b % m)) % m; }
ll mod_mul(ll a, ll b, ll m = MOD) { return ((a % m) * (b + m) % m); }
ll mod_pow(ll a, ll b, ll m = MOD) {
  ll res = 1;
  while (b) {
    if (b & 1) {
      res = (res * a) % m;
    }
    a = (a * a) % m;
    b >>= 1;
  }

  return res;
}

void fast() {
  std::ios::sync_with_stdio(false);
  std::cin.tie(nullptr);
}

std::vector<int> prefixFunction(const std::string& s) {
  int n = s.size();
  std::vector<int> pi(n);
  for (int i = 1; i < n; ++i) {
    int j = pi[i - 1];
    while (j > 0 && s[i] != s[j]) {
      j = pi[j - 1];
    }
    if (s[i] == s[j]) {
      j++;
    }
    pi[i] = j;
  }

  return pi;
}

int kmp(const std::string& P, const std::string& T) {
  int ps = P.size();
  int ts = T.size();
  int counter = 0;
  std::vector<int> pi = prefixFunction(P + "#" + T);
  for (int i = 0; i < ts; ++i) {
    if (pi[ps + i + 1] == ps) {
      counter += 1;
    }
  }

  return counter;
}

unsigned long long reverseBits(ull x) {
  ull r = 0;
  while (x) {
    r = (r << 1) | (x & 1);
    x >>= 1;
  }
  return r;
}

ull reverseb(ull x) {
  ull r = 0;
  while (x) {
    r = (r << 1) | (x & 1);
    x >>= 1;
  }
  return r;
}

void solve() {
  ull n;
  std::cin >> n;
  int s = 0;
  while (n > 0) {
    ull r = reverseb(n);
    n = r - 1;
    ++s;
  }

  std::cout << s << '\n';
}

int main(int argc, char** argv) {
  fast();
  int t = 1;
  // std::cin >> t;
  while (t--) {
    solve();
  }
  return EXIT_SUCCESS;
}