def f_build(n):
    tree = [0] * (n + 1)
    for i in range(1, n + 1):
        j = i
        while j <= n:
            tree[j] += 1
            j += j & -j
    return tree


def f_add(tree, i, delta):
    n = len(tree) - 1
    while i <= n:
        tree[i] += delta
        i += i & -i


def f_find_kth(tree, k):
    n = len(tree) - 1
    pos = 0
    bit = 1
    while (bit << 1) <= n:
        bit <<= 1
    curr = 0
    while bit:
        nxt = pos + bit
        if nxt <= n and curr + tree[nxt] < k:
            curr += tree[nxt]
            pos = nxt
        bit >>= 1
    return pos + 1


def main():
    n = int(input().strip())
    a = []

    while len(a) < n:
        line = input().strip()
        if line:
            a.extend(map(int, line.split()))
    a = a[:n]
    
    tree = f_build(n) 
    p = [0] * n

    for i in range(1, n + 1):
        total_free = n - i + 1
        k_left = total_free - a[i - 1]
        idx = f_find_kth(tree, k_left)
        p[idx - 1] = i
        f_add(tree, idx, -1)

    print(*p)


if __name__ == "__main__":
    main()
