def position(pos):
    notes = "ABCDEFG"
    return notes[(pos-1)%7]

def posibility(melody):
    possibilities = []
    start = melody[0]
    
    note_positions = {}
    for pos in range(1, 53):
        note = position(pos)
        if note not in note_positions:
            note_positions[note] = []
        note_positions[note].append(pos)
    
    startpositions = note_positions[start]
    
    for startpos in startpositions:
        able = True
        current_pos = startpos
        
        for i in range(1, len(melody)):
            next_note = melody[i]
            found = False
            
            for candidate_pos in note_positions[next_note]:
                if abs(candidate_pos - current_pos) <= 3:
                    current_pos = candidate_pos
                    found = True
                    break
            
            if not found:
                able = False
                break
        
        if able:
            possibilities.append("YES")
    
    return "YES" if possibilities else "NO"

n = int(input())
melodies = []
for _ in range(n):
    melodies.append(input().strip().upper())

for melody in melodies:
    result = posibility(melody)
    print(result)