#include <bits/stdc++.h>
using namespace std;

bool can_play(const string &s, const vector<vector<int>> &pos) {
    vector<int> cur = pos[s[0] - 'A'];
    for (int k = 1; k < (int)s.size(); k++) {
        char ch = s[k];
        const auto &cand = pos[ch - 'A'];
        vector<int> nxt;
        int i = 0, j = 0;
        while (i < (int)cur.size() && j < (int)cand.size()) {
            if (abs(cur[i] - cand[j]) <= 3) {
                nxt.push_back(cand[j]);
                j++;
            } else if (cur[i] < cand[j] - 3) {
                i++;
            } else {
                j++;
            }
        }
        if (nxt.empty()) return false;
        cur.swap(nxt);
    }
    return true;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    cin >> t;

    // 52 белые клавиши: A..G по кругу
    vector<vector<int>> pos(7);
    for (int i = 0; i < 52; i++) {
        int letter = i % 7;  // 0 = A, 1 = B, ..., 6 = G
        pos[letter].push_back(i);
    }

    while (t--) {
        string s;
        cin >> s;
        cout << (can_play(s, pos) ? "Yes" : "No") << '\n';
    }
    return 0;
}
