def read_ints():
    for token in input_data.strip().split():
        yield token

input_data = ''
try:
    while True:
        input_data += input() + '\n'
except EOFError:
    pass

it = read_ints()
try:
    n = int(next(it))
except StopIteration:
    exit()

R = n - 1
coords = []
for z in range(-R, R + 1):
    xmin = max(-R, -z - R)
    xmax = min(R, -z + R)
    for x in range(xmin, xmax + 1):
        y = -x - z
        coords.append((x, y, z))

cells_count = len(coords)
vals = []
for _ in range(cells_count):
    try:
        vals.append(int(next(it)))
    except StopIteration:
        vals.append(0)

ops_chars = []
for token in it:
    ops_chars.append(token)
ops = "".join(ops_chars).strip()

def mat_mul(A, B):
    return [
        [A[0][0]*B[0][0] + A[0][1]*B[1][0] + A[0][2]*B[2][0],
         A[0][0]*B[0][1] + A[0][1]*B[1][1] + A[0][2]*B[2][1],
         A[0][0]*B[0][2] + A[0][1]*B[1][2] + A[0][2]*B[2][2]],
        [A[1][0]*B[0][0] + A[1][1]*B[1][0] + A[1][2]*B[2][0],
         A[1][0]*B[0][1] + A[1][1]*B[1][1] + A[1][2]*B[2][1],
         A[1][0]*B[0][2] + A[1][1]*B[1][2] + A[1][2]*B[2][2]],
        [A[2][0]*B[0][0] + A[2][1]*B[1][0] + A[2][2]*B[2][0],
         A[2][0]*B[0][1] + A[2][1]*B[1][1] + A[2][2]*B[2][1],
         A[2][0]*B[0][2] + A[2][1]*B[1][2] + A[2][2]*B[2][2]],
    ]

def mat_vec_mul(M, v):
    x, y, z = v
    return (M[0][0]*x + M[0][1]*y + M[0][2]*z,
            M[1][0]*x + M[1][1]*y + M[1][2]*z,
            M[2][0]*x + M[2][1]*y + M[2][2]*z)

M_R = [[0, 0, -1],
       [-1, 0, 0],
       [0, -1, 0]]
M_L = [[0, -1, 0],
       [0, 0, -1],
       [-1, 0, 0]]
M_T = [[0, 1, 0],
       [1, 0, 0],
       [0, 0, 1]]

M_total = [[1,0,0],[0,1,0],[0,0,1]]
for ch in ops:
    if ch == 'R':
        M_total = mat_mul(M_R, M_total)
    elif ch == 'L':
        M_total = mat_mul(M_L, M_total)
    elif ch == 'T':
        M_total = mat_mul(M_T, M_total)

final_map = {}
for i, coord in enumerate(coords):
    final_coord = mat_vec_mul(M_total, coord)
    final_map[final_coord] = vals[i]

out_lines = []
for z in range(-R, R + 1):
    xmin = max(-R, -z - R)
    xmax = min(R, -z + R)
    row_vals = []
    for x in range(xmin, xmax + 1):
        y = -x - z
        v = final_map.get((x,y,z), 0)
        row_vals.append(str(v))
    out_lines.append(" ".join(row_vals))

print("\n".join(out_lines))
