import sys


def mat_mul(A, B):
    return [
        [
            A[0][0] * B[0][0] + A[0][1] * B[1][0] + A[0][2] * B[2][0],
            A[0][0] * B[0][1] + A[0][1] * B[1][1] + A[0][2] * B[2][1],
            A[0][0] * B[0][2] + A[0][1] * B[1][2] + A[0][2] * B[2][2]
        ],
        [
            A[1][0] * B[0][0] + A[1][1] * B[1][0] + A[1][2] * B[2][0],
            A[1][0] * B[0][1] + A[1][1] * B[1][1] + A[1][2] * B[2][1],
            A[1][0] * B[0][2] + A[1][1] * B[1][2] + A[1][2] * B[2][2]
        ],
        [
            A[2][0] * B[0][0] + A[2][1] * B[1][0] + A[2][2] * B[2][0],
            A[2][0] * B[0][1] + A[2][1] * B[1][1] + A[2][2] * B[2][1],
            A[2][0] * B[0][2] + A[2][1] * B[1][2] + A[2][2] * B[2][2]
        ]
    ]


def mat_vec_mul(M, v):
    x, y, z = v
    return (
        M[0][0] * x + M[0][1] * y + M[0][2] * z,
        M[1][0] * x + M[1][1] * y + M[1][2] * z,
        M[2][0] * x + M[2][1] * y + M[2][2] * z
    )


def main():
    data = sys.stdin.read().splitlines()
    if not data:
        return

    n = int(data[0].strip())
    R = n - 1

    tokens = []
    for line in data[1:]:
        if line.strip():
            tokens.extend(line.strip().split())

    z_list = list(range(-R, R + 1))
    counts = []
    xmin_list = []
    for z in z_list:
        xmin = max(-R, -z - R)
        xmax = min(R, -z + R)
        count = xmax - xmin + 1
        counts.append(count)
        xmin_list.append(xmin)

    total_cells = sum(counts)

    offsets = [0] * len(z_list)
    for i in range(1, len(z_list)):
        offsets[i] = offsets[i - 1] + counts[i - 1]

    if len(tokens) < total_cells:
        tokens.extend(['0'] * (total_cells - len(tokens)))

    vals = list(map(int, tokens[:total_cells]))
    ops = "".join(tokens[total_cells:]).strip()

    M_R = [[0, 0, -1],
           [-1, 0, 0],
           [0, -1, 0]]
    M_L = [[0, -1, 0],
           [0, 0, -1],
           [-1, 0, 0]]
    M_T = [[0, 1, 0],
           [1, 0, 0],
           [0, 0, 1]]

    M_total = [[1, 0, 0], [0, 1, 0], [0, 0, 1]]
    for ch in ops:
        if ch == 'R':
            M_total = mat_mul(M_R, M_total)
        elif ch == 'L':
            M_total = mat_mul(M_L, M_total)
        elif ch == 'T':
            M_total = mat_mul(M_T, M_total)

    M_inv = [
        [M_total[0][0], M_total[1][0], M_total[2][0]],
        [M_total[0][1], M_total[1][1], M_total[2][1]],
        [M_total[0][2], M_total[1][2], M_total[2][2]]
    ]

    output_lines = []
    for i, z in enumerate(z_list):
        xmin = xmin_list[i]
        xmax = xmin + counts[i] - 1
        row_vals = []
        for x in range(xmin, xmax + 1):
            y = -x - z

            x0, y0, z0 = mat_vec_mul(M_inv, (x, y, z))


            idx_z0 = z0 + R
            if 0 <= idx_z0 < len(z_list):
                xmin0 = xmin_list[idx_z0]
                idx = offsets[idx_z0] + (x0 - xmin0)
                if 0 <= idx < total_cells:
                    row_vals.append(str(vals[idx]))
                    continue


            row_vals.append('0')

        output_lines.append(" ".join(row_vals))

    print("\n".join(output_lines))


if __name__ == '__main__':
    main()