import sys
import math

M = 20000000
cost = [-1] * (M + 1)
sys.setrecursionlimit(2000)

def digit_len(n):
    if n <= 0:
        return 1
    return math.floor(math.log10(n)) + 1

def collatz(n):
    return n // 2 if n % 2 == 0 else 3 * n + 1

def get_collatz_cost(x):
    if x == 1:
        return 0
    if x <= M and cost[x] != -1:
        return cost[x]
    c = collatz(x)
    tmp = digit_len(c) + get_collatz_cost(c)
    if x <= M:
        cost[x] = tmp
    return tmp

cost[1] = 0
for x in range(2, M + 1):
    get_collatz_cost(x)

prefix = [0] * (M + 2)
for y in range(1, M + 1):
    prefix[y] = prefix[y - 1] + digit_len(y) + cost[y]

random_x = set()
max_random = M // 6
for x in range(2, max_random + 1):
    l = 3 * x + 1
    r = 6 * x
    num = r - l + 1
    s = prefix[r] - prefix[l - 1]
    avg = s / num
    cost_collatz = cost[x]
    if avg < cost_collatz:
        random_x.add(x)

t = int(input())
for _ in range(t):
    current = int(input())
    while True:
        action = "random" if current <= max_random and current in random_x else "collatz"
        print(action)
        sys.stdout.flush()
        new = int(input())
        if new == 0:
            sys.exit()
        current = new
        if current == 1:
            break