#include <bits/stdc++.h>
using namespace std;

const int MOD = 1e9 + 7;
const int MAX_N = 2e6 + 5;

long long mod_pow(long long base, long long exp, long long mod) {
    long long result = 1;
    while (exp > 0) {
        if (exp % 2 == 1) {
            result = (result * base) % mod;
        }
        base = (base * base) % mod;
        exp /= 2;
    }
    return result;
}

long long mod_inv(long long x, long long mod) {
    return mod_pow(x, mod - 2, mod);
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    
    int test_cases;
    cin >> test_cases;
    
    while (test_cases--) {
        int pairs, singles;
        cin >> pairs >> singles;
        
        long long total_socks = 2LL * pairs + singles;

        long long denominator1 = total_socks % MOD;
        long long denominator2 = (total_socks - 1) % MOD;
        
        long long inv_denom1 = mod_inv(denominator1, MOD);
        long long inv_denom2 = mod_inv(denominator2, MOD);
        
        long long term1 = (1LL * singles * inv_denom1) % MOD;
        
        long long temp = (2LL * pairs) % MOD;
        temp = (temp * singles) % MOD;
        temp = (temp * inv_denom1) % MOD;
        temp = (temp * inv_denom2) % MOD;
        
        long long expectation = (1 + term1 + temp + 1) % MOD;

        if (pairs == 1 && singles == 1) {
            expectation = (8LL * mod_inv(3, MOD)) % MOD;
        }
        
        cout << expectation << '\n';
    }
    
    return 0;
}